"""
Сериализаторы ответов на запрос свойств ссылок
"""

from rest_framework import serializers


class ExplainLinksInputSerializer(serializers.Serializer):
    """
    Сериализатор для explainlinks
    """

    links = serializers.DictField(child=serializers.ListField(child=serializers.CharField()))


class ExplainLinksSerializer(serializers.Serializer):
    links = serializers.DictField(
        # child - это значение, лежащее в словаре.
        child=serializers.IntegerField()
    )
