from rest_framework import serializers


class ForcedSyncRequest(serializers.Serializer):
    force = serializers.BooleanField(required=False, default=False)
    org_id = serializers.CharField(required=False)
    cloud_org_id = serializers.CharField(required=False)
    cloud_uid = serializers.CharField(required=False)
    uid = serializers.CharField(required=False)
    user_iam_token = serializers.CharField(required=False)

    default_error_messages = {
        'cloud_uid_or_uid_required': '"cloud_uid" or "uid" parameter is required',
        'org_id_or_user_iam_token': '"org_id" or "user_iam_token" parameter is required',
        'cloud_org_id_and_user_iam_token': 'if exists "cloud_org_id" then parameter "user_iam_token" is required',
    }

    def validate(self, attrs):
        if not attrs.get('cloud_uid') and not attrs.get('uid'):
            self.fail('cloud_uid_or_uid_required')

        if not attrs.get('org_id') and not attrs.get('user_iam_token'):
            self.fail('org_id_or_user_iam_token')

        if attrs.get('cloud_org_id') and not attrs.get('user_iam_token'):
            self.fail('cloud_org_id_and_user_iam_token')

        return attrs
