
from rest_framework import serializers

from wiki.api_frontend.serializers.grids import errors
from wiki.api_frontend.serializers.grids.change_grid.base import StructureChanger


class GridTitleChanged(StructureChanger, serializers.Serializer):
    """
    Десериализация, валидация запроса и логика изменения названия грида.
    """

    title = serializers.CharField(required=True, min_length=1, max_length=255, trim_whitespace=True)

    def apply_change(self, user, obj, user_version, title, **kwargs):
        """
        Изменить название.

        @type obj: Grid
        @type user_version: Grid
        @type title: string
        """
        self.check_conflicts(actual_version=obj, user_version=user_version)

        structure = obj.access_structure.copy()
        structure['title'] = title
        obj.access_structure = structure
        obj.title = title

        return obj

    def check_conflicts(self, actual_version, user_version):
        user_version_title = user_version.access_structure['title']
        current_title = actual_version.access_structure['title']

        if user_version_title != current_title:
            raise errors.TitleHasChangedError(
                {
                    'actual_grid_version': current_title,
                    'your_version': user_version_title,
                }
            )
