"""
Содержит значения полей для создаваемых колонок.
"""
from wiki.grids.utils.base import SELECT_TYPE, STAFF_TYPE, native_field_types


def for_string():
    return {
        'raw': '',
    }


def for_checkbox():
    return {
        'raw': False,
    }


def for_anything_else():
    # По аналогии со старым кодом ставим '' в качестве дефолта
    # Потом можно будет пересмотреть это место, если необходимо
    return {
        'raw': '',
        'transformed': [],
    }


def for_staff():
    return {
        'raw': [],
    }


def for_number():
    # По аналогии со старым кодом ставим '' в качестве дефолта
    # Потом можно будет пересмотреть это место, если необходимо
    return {
        'raw': '',
    }


def for_select():
    return {
        'raw': [],
    }


type_map = {
    'string': for_string(),
    'date': for_anything_else(),
    'number': for_number(),
    'checkbox': for_checkbox(),
    STAFF_TYPE: for_staff(),
    SELECT_TYPE: for_select(),
}


class NotFullyInitialized(Exception):
    """
    Дикт type_map не до конца заполнен.
    В type_map ключи должны совпадать с ключами из the_field_types.
    """

    pass


# проверка на полноту type_map. Производится не в рантайме, а при инициализации
if any(key not in type_map for key in native_field_types):
    raise NotFullyInitialized()
