
from rest_framework import serializers

from wiki.api_frontend.serializers.grids.change_grid.base import StructureChanger
from wiki.api_frontend.serializers.grids.errors import ConflictingChangeError, NoSuchColumnError


class GridColumnMoved(StructureChanger, serializers.Serializer):
    id = serializers.CharField()
    after_id = serializers.CharField()

    def apply_change(self, user, server_grid, user_grid, id, after_id, **kwargs):
        """
        Переместить столбец.

        @type server_grid: Grid
        @type user_grid: Grid
        @type id: str
        @type after_id: str
        """

        # просто формальная проверка наличия столбцов в пользовательской версии
        # (если всё работает штатно, они всегда там есть)
        if user_grid.column_by_name(id) is None or after_id != '-1' and user_grid.column_by_name(after_id) is None:
            raise NoSuchColumnError(debug_message='does not exist in YOUR version')

        column = server_grid.column_by_name(id)
        if column is None:
            raise NoSuchColumnError

        struct = server_grid.access_structure.copy()
        fields = struct['fields']

        old_idx = fields.index(column)

        if after_id == '-1':
            new_idx = 0
        else:
            after_column = server_grid.column_by_name(after_id)
            if after_column is None:
                raise ConflictingChangeError(debug_message='column to insert after does not exist in server version')
            new_idx = fields.index(after_column)
            if new_idx < old_idx:
                new_idx += 1

        fields.pop(old_idx)
        fields.insert(new_idx, column)

        server_grid.access_structure = struct

        return server_grid
