
from rest_framework import serializers

from wiki.api_frontend.serializers.grids.change_grid.base import RowOrderChanger
from wiki.api_frontend.serializers.grids.errors import NoMoveTargetRowsError, NoSuchRowError


class GridRowMoved(RowOrderChanger, serializers.Serializer):
    id = serializers.CharField(max_length=20)
    after_id = serializers.CharField(max_length=20)
    before_id = serializers.CharField(max_length=20)

    def apply_change(self, user, server_grid, user_grid, id, after_id, before_id, **kwargs):
        """
        Переместить строку.

        @type server_grid: Grid
        @type id: str
        @type after_id: str
        """

        if id not in server_grid.access_idx:
            # строки уже нет, ее нельзя переместить
            raise NoSuchRowError

        if after_id == '-1':
            # строку передвигаем в начало
            after_idx = -1
        else:
            after_idx = server_grid.access_idx.get(after_id)
            if after_idx is None:
                # нет уже строки, "после которой"
                if before_id == '-1':
                    # строку передвигаем в конец
                    after_idx = len(server_grid.access_data) - 1
                else:
                    before_idx = server_grid.access_idx.get(before_id)
                    if before_idx is None:
                        # и строки "перед которой" тоже уже нет
                        raise NoMoveTargetRowsError
                    after_idx = before_idx - 1

        server_grid.move_after_idx([id], after_idx)

        return server_grid
