
from rest_framework import serializers

from wiki.api_core.errors.bad_request import InvalidDataSentError
from wiki.api_frontend.serializers.grids.change_grid.base import StructureChanger


def row_by_row_id(grid, row):
    """
    Вернуть ячейку по именам столбца и строки.

    @type grid: Grid
    @type row: basestring
    @rtype: dict|None
    """
    return grid.access_data[grid.access_idx[row]]


class GridColumnRemoved(StructureChanger, serializers.Serializer):
    """
    Сериализатор удаления столбца.
    """

    name = serializers.CharField()

    def apply_change(self, user, obj, user_version, name, **kwargs):
        """
        Удалить столбец.

        @type obj: Grid
        @type user_version: Grid
        @type name: basestring
        """
        try:
            obj.remove_column(name)
        except ValueError:
            raise InvalidDataSentError('Grid has ticket dependent columns, delete them first')
        return obj
