
from rest_framework import serializers

from wiki.api_frontend.serializers.grids.change_grid.base import LamportClock
from wiki.grids.utils import row_change_action
from wiki.notifications.models import PageEvent


class GridRowRemoved(LamportClock, serializers.Serializer):
    """
    Сериализатор удаления строки.
    """

    id = serializers.CharField(max_length=20)

    # удаляемая строка
    deleted_row = None
    # лапша-код, флаг который передает состояние из save_object в increment_version
    has_been_deleted = False

    def apply_change(self, user, grid, user_version, id, **kwargs):
        """
        Удалить строку и записать в old_state_of_row эту строку.

        @type grid: Grid
        @type id: str
        """
        data = grid.access_data

        try:
            new_idx = grid.access_idx[id]
            new_row = grid.access_data[new_idx]
        except KeyError:
            # такой строчки уже нет, поэтому считаем операцию успешной.
            return grid

        grid.remove([id])
        self.has_been_deleted = True
        self.deleted_row = new_row

        grid.access_data = data

        return grid

    def increment_version(self, user, grid):
        # неявно увеличивает счетчик.
        if not self.has_been_deleted:
            # операция была доведена до конца,
            # но строка не была удалена, не надо записывать операцию в лог.
            return

        row_change_action[PageEvent.EVENT_TYPES.delete](self.deleted_row, user, grid)
