
from rest_framework import serializers


class ImportDataParsePreviewSerializer(serializers.Serializer):
    """
    Сериализатор импортируемых данных, полученных при разборе файла.
    Используется для предварительного просмотра результатов работы парсера.
    """

    cache_key = serializers.ReadOnlyField()
    column_count = serializers.ReadOnlyField()
    row_count = serializers.ReadOnlyField()
    rows = serializers.ReadOnlyField()


class ImportDataPreviewSerializer(serializers.Serializer):
    """
    Сериализатор данных для предварительного просмотра результатов импорта данных в табличный список.
    """

    cache_key = serializers.ReadOnlyField()
    column_count = serializers.ReadOnlyField()
    row_count = serializers.ReadOnlyField()
    import_columns = serializers.ReadOnlyField()
    column_data_types = serializers.ReadOnlyField()
    existing_columns = serializers.ReadOnlyField()
    existing_rows = serializers.ReadOnlyField()
    imported_rows = serializers.ReadOnlyField()
    fields = serializers.ReadOnlyField()
