
from rest_framework import serializers

from wiki.api_frontend.serializers.grids.grid import GridDataSerializer
from wiki.api_frontend.serializers.io import VersionedStatusSerializer


class FullGridVersionedStatusSerializer(VersionedStatusSerializer):
    """
    Медленный сериализатор результата операции, отвечающий всем документом.
    """

    grid = GridDataSerializer()


class CellVersionedStatusSerializer(VersionedStatusSerializer):
    """
    Сериализатор результата изменения ячейки, который возвращает bemjson и
    получившуюся версию документа.
    """

    cell = serializers.ReadOnlyField()
