
from rest_framework import serializers

from wiki.utils.rest_framework import fields


class MoveMetainfoSerializer(serializers.Serializer):
    subpages_count = serializers.SerializerMethodField()

    def get_subpages_count(self, value):
        return value.descendants.count()


class MoveClusterSerializer(serializers.Serializer):
    destination = fields.TagField(page_should_exist=False)
    move_cluster = serializers.BooleanField()
