"""
Сериализаторы для объектов ввода-вывода
"""
from rest_framework import serializers
from rest_framework.response import Response


class StatusSerializer(serializers.Serializer):
    """
    Ответ о завершении операции
    """

    success = serializers.BooleanField(default=True)
    message = serializers.CharField(max_length=1000, required=False)


class VersionedStatusSerializer(StatusSerializer):
    """
    Сериализатор результата операции, отвечающий версией документа.
    """

    version = serializers.CharField(source='get_page_version')


class EmptySerializer(serializers.Serializer):
    """
    Пустой ответ, соответствует выполненной операции без ошибок и конкретных результатов
    """


def ok_response():
    """
    Шорткат
    @return:
    """
    return Response(StatusSerializer({'success': True}).data)
