from rest_framework import serializers

from wiki.api_core.serializers import UserSerializer


class OwnerSerializer(serializers.Serializer):
    owner = UserSerializer()


class ChangeOwnerSerializer(serializers.Serializer):
    new_owner = UserSerializer(should_be_dismissed=False)
    old_owner = UserSerializer(required=False)
    with_subpages = serializers.BooleanField(required=False, default=False)

    default_error_messages = {
        'old_owner_without_subpages': '`old_owner` option make sense only with option `with_subpages=True`'
    }

    def validate(self, attrs):
        old_owner = attrs.get('old_owner')
        if old_owner and not attrs['with_subpages']:
            self.fail('old_owner_without_subpages')
        return attrs
