from rest_framework import serializers


class PageReadonlyModeSerializer(serializers.Serializer):
    """
    Сериализатор атибутов режима read-only страницы.
    """

    is_readonly = serializers.BooleanField()


class PageReadonlyModeDeserializer(serializers.Serializer):
    """
    Десериализатор атрибутов режима read-only страницы.
    """

    is_readonly = serializers.BooleanField()
    for_cluster = serializers.BooleanField()
