from enum import Enum
from enumfields.drf.fields import EnumField
from rest_framework import serializers


class OrderType(str, Enum):
    RELEVANCY = 'relevancy'
    CREATION_DATE = 'creation_date'
    MODIFIED_DATE = 'modified_date'


class DocumentType(str, Enum):
    FILE = 'file'
    PAGE = 'page'
    GRID = 'grid'


class TypeSerializer(serializers.Serializer):
    equal = EnumField(DocumentType)


class SlugSerializer(serializers.Serializer):
    prefix = serializers.CharField(required=True)


class DateSerializer(serializers.Serializer):
    from_ = serializers.IntegerField(required=False, source='from')
    to = serializers.IntegerField(required=False)


class AuthorsSerializer(serializers.Serializer):
    contains = serializers.ListField(required=False, child=serializers.CharField())
    equal = serializers.ListField(required=False, child=serializers.CharField())


class FilterSerializer(serializers.Serializer):
    type = TypeSerializer(required=False)

    authors_uid = AuthorsSerializer(required=False)
    authors_cloud_uid = AuthorsSerializer(required=False)

    slug = SlugSerializer(required=False)

    created_at = DateSerializer(required=False)
    modified_at = DateSerializer(required=False)


class QueryViewSerializer(serializers.Serializer):
    """
    Используется для валидации query POST-запросов к cloudsearch
    """

    query = serializers.CharField(required=True, allow_blank=True)  # Пустой запрос не должен 400 -> отдаем пустой ответ

    page_id = serializers.IntegerField(min_value=1, required=True)
    page_size = serializers.IntegerField(min_value=1, required=True)

    order_by = EnumField(OrderType, default=OrderType.RELEVANCY)

    fuzzy = serializers.BooleanField(default=False)

    filters = FilterSerializer(required=False)
