
from rest_framework import serializers

from wiki.notifications import signals


class RequestOwnershipSerializer(serializers.Serializer):
    """
    Используется для валидации параметров запроса на владение страницами
    и создания уведомления о запросе.
    """

    root_page_only = serializers.BooleanField(required=False, default=False)
    reason = serializers.CharField(required=True, min_length=1, trim_whitespace=True)

    def save(self, user, page):
        signals.request_ownership_created(
            page=page, requester=user, root_page_only=self.data['root_page_only'], reason=self.data['reason']
        )
