
from rest_framework import serializers

from wiki.notifications import signals


class RequestPageAuthorSerializer(serializers.Serializer):
    """
    Используется для валидации параметров запроса на добавление в авторы страницы
    и создания уведомления о запросе.
    """

    reason = serializers.CharField(required=True, min_length=1, trim_whitespace=True)

    def save(self, user, page):
        signals.request_page_author_created(page=page, requester=user, reason=self.data['reason'])
