
from model_utils import Choices
from rest_framework import serializers

from wiki.users.logic import settings as settings_logic


class SettingsSerializer(serializers.Serializer):
    """
    Используется для сериализации/десериализации пользовательских настроек.
    """

    default_error_messages = {
        'something_required': 'At least one of fields must not be empty',
    }

    LANGUAGES = Choices(
        ('ru', 'RU'),
        ('en', 'EN'),
    )
    language = serializers.ChoiceField(
        choices=LANGUAGES,
        required=False,
    )
    code_theme = serializers.ChoiceField(
        choices=settings_logic.CODE_THEMES,
        required=False,
    )
    propose_content_translation = serializers.BooleanField(
        required=False,
    )
    use_nodejs_frontend = serializers.BooleanField(
        required=False,
    )
    use_full_width_content = serializers.BooleanField(
        required=False,
    )
    use_new_wf = serializers.BooleanField(
        required=False,
    )
    ui_theme = serializers.ChoiceField(
        choices=settings_logic.UI_THEMES,
        required=False,
    )

    def validate(self, attrs):
        if not attrs:
            self.fail('something_required')
        return attrs
