from rest_framework import serializers

from wiki.api_core.errors.bad_request import InvalidDataSentError


class StaffSerializer(serializers.Serializer):
    """
    Сериализатор ответа для ручки получения данных про staff.
    """

    available_languages = ('ru', 'en')

    def to_representation(self, staff, request=None):
        lang = self.context['lang'] if self.context else 'ru'

        if lang not in self.available_languages:
            raise InvalidDataSentError('Language must be one of {langs}'.format(langs=self.available_languages))

        def get_first_name():
            return staff.first_name if lang == 'ru' else staff.first_name_en

        def get_last_name():
            return staff.last_name if lang == 'ru' else staff.last_name_en

        def is_dismissed():
            return staff.is_dismissed if hasattr(staff, 'is_dismissed') else False

        return {'first_name': get_first_name(), 'last_name': get_last_name(), 'is_dismissed': is_dismissed()}
