
from rest_framework import serializers

from wiki.pages.pages_tree_new import Sort, SortBy


class TreeRequestDeserializer(serializers.Serializer):
    """
    Десериализатор GET запроса к TreeView.
    """

    depth = serializers.IntegerField(min_value=0, default=3)
    show_redirects = serializers.BooleanField(default=False)
    show_grids = serializers.BooleanField(default=True)
    show_files = serializers.BooleanField(default=False)
    show_owners = serializers.BooleanField(default=False)
    show_titles = serializers.BooleanField(default=True)
    show_created_at = serializers.BooleanField(default=False)
    show_modified_at = serializers.BooleanField(default=False)
    sort_by = serializers.ChoiceField(choices=SortBy.CHOICES, default=SortBy.DEFAULT)
    sort = serializers.ChoiceField(choices=Sort.CHOICES, default=Sort.DEFAULT)
    authors = serializers.CharField(required=False, default='')
