from rest_framework import serializers

from wiki.api_core.serializers import DateTimeTzAwareField


class TreeClusterSerializer(serializers.Serializer):
    """
    Сериализатор атрибутов страницы для отображения дерева кластера.
    """

    tag = serializers.CharField()
    url = serializers.CharField()
    title = serializers.CharField()
    modified_at = DateTimeTzAwareField()
    created_at = DateTimeTzAwareField()
    page_type = serializers.CharField()
    children_count = serializers.IntegerField(min_value=0)
