from django.conf import settings
from django.conf.urls import include, url

from wiki.api_core import framework
from wiki.async_operations.views import AsyncRequestResultViewRecent
from wiki.async_operations.operation_executors.debug_operation.drf_view import TestAsyncOperationView
from wiki.async_operations.operation_executors.move_cluster.drf_view import MoveClusterView
from wiki.async_process.views import AsyncRequestResultView, TestAsyncRequestView
from wiki.cloudsearch.views.get_acl import GetAcl
from wiki.cloudsearch.views.query_view import QueryView
from wiki.cloudsearch.views.get_document import GetDocument

from . import views

page_patterns = [
    url(r'^$', views.PageView.as_view(), {'api_type': 'frontend'}, name='page'),
    url(r'^\.raw$', views.RawPageView.as_view(), {'api_type': 'frontend'}, name='raw_page_markup'),
    url(r'^\.access$', views.AccessView.as_view(), {'api_type': 'frontend'}, name='access'),
    url(r'^\.officiality$', views.OfficialityView.as_view(), {'api_type': 'frontend'}, name='officiality'),
    # comment views
    url(
        r'^\.comments$',
        views.CommentsListView.as_view(),
        {'api_type': 'frontend'},
        name='comments_list',
    ),
    url(
        r'^\.comments/(?P<pk>[0-9]+)$',
        views.CommentDetailView.as_view(),
        {'api_type': 'frontend'},
        name='comments_detail',
    ),
    url(r'^\.comments/status', views.CommentsStatusView.as_view(), {'api_type': 'frontend'}, name='comments_status'),
    # events & revisions
    url(r'^\.events$', views.PageEventsView.as_view(), {'api_type': 'frontend'}, name='page_events'),
    url(r'^\.revisions$', views.RevisionListView.as_view(), {'api_type': 'frontend'}, name='list_revisions'),
    url(r'^\.revisions/(?P<revision_id>\d+)$', views.RevisionView.as_view(), {'api_type': 'frontend'}, name='revision'),
    url(
        r'^\.changes/(?P<version>\d+)$',
        views.GridConcurrentChangesView.as_view(),
        {'api_type': 'frontend'},
        name='changes',
    ),
    # files
    url(r'^\.files$', views.FilesListView.as_view(), {'api_type': 'frontend'}, name='page_files'),
    url(r'^\.files/(?P<filename>.+)$', views.FileView.as_view(), {'api_type': 'frontend'}, name='page_file'),
    # diff
    url(r'^\.diff$', views.DiffView.as_view(), {'api_type': 'frontend'}, name='page_diff'),
    url(r'^\.groups/(?P<group_id>\d+)$', views.GroupView.as_view(), {'api_type': 'frontend'}, name='groups'),
    url(r'^\.keywords$', views.KeywordsView.as_view(), {'api_type': 'frontend'}, name='keywords'),
    url(r'^\.watch$', views.WatchView.as_view(), {'api_type': 'frontend'}, name='subscribe'),
    url(r'^\.masswatch$', views.MassWatchView.as_view(), {'api_type': 'frontend'}, name='subscribe_with_children'),
    url(r'^\.unwatch$', views.UnwatchView.as_view(), {'api_type': 'frontend'}, name='unsubscribe'),
    url(
        r'^\.massunwatch$', views.MassUnwatchView.as_view(), {'api_type': 'frontend'}, name='unsubscribe_with_children'
    ),
    url(r'^\.watchers$', views.WatchersView.as_view(), {'api_type': 'frontend'}, name='watchers'),
    url(r'^\.grid$', views.GridDataView.as_view(), {'api_type': 'frontend'}, name='grid_data'),
    url(r'^\.grid/create$', views.CreateGridView.as_view(), {'api_type': 'frontend'}, name='create_grid'),
    url(r'^\.grid/replace$', views.ReplaceGridView.as_view(), {'api_type': 'frontend'}, name='replace_grid'),
    url(r'^\.grid/change$', views.ChangeGridView.as_view(), {'api_type': 'frontend'}, name='change_grid'),
    url(
        # ручка создания строки, возвращающая ее id
        r'^\.grid/rows$',
        views.GridRowsView.as_view(),
        {'api_type': 'frontend'},
        name='grid.rows',
    ),
    url(
        # медленная ручка специально для фронтэнда. Алиас к ChangeGridView
        r'^\.grid/change_and_get_document$',
        views.ChangeGridAndGetItAllBackView.as_view(),
        {'api_type': 'frontend'},
        name='change_grid_and_get_it_all',
    ),
    url(
        # медленная ручка специально для фронтэнда. Похожа на ChangeGridView
        r'^\.grid/change_get_cell',
        views.ChangeCellAndGetBemJson.as_view(),
        {'api_type': 'frontend'},
        name='change_get_cell',
    ),
    url(
        r'^\.grid/export/(?P<format_type>csv|xls|docx)$',
        views.GridExportView.as_view(),
        {'api_type': 'frontend'},
        name='grid_export',
    ),
    url(
        r'^\.grid/revisions/(?P<revision_id>\d+)$',
        views.GridRevisionView.as_view(),
        {'api_type': 'frontend'},
        name='grid_revision',
    ),
    url(
        r'^\.grid/revisions/(?P<revision_id>\d+)/rollback$',
        views.GridRollbackView.as_view(),
        {'api_type': 'frontend'},
        name='grid_rollback',
    ),
    url(r'^\.grid/clone$', views.GridCloneView.as_view(), {'api_type': 'frontend'}, name='grid_clone'),
    url(r'^\.grid/import$', views.ImportDataView.as_view(), {'api_type': 'frontend'}, name='import_grid'),
    url(r'^\.move$', views.MoveClusterView.as_view(), {'api_type': 'frontend'}, name='move_cluster'),
    url(r'^\.move_async$', views.MoveClusterViewAsync.as_view(), {'api_type': 'frontend'}, name='move_cluster'),
    url(r'^\.redirect', views.RedirectView.as_view(), {'api_type': 'frontend'}, name='redirect'),
    url(
        r'^\.translate/(?P<tr_lang>[a-z]{2}-[a-z]{2})$',
        views.TranslateView.as_view(),
        {'api_type': 'frontend'},
        name='translate',
    ),
    url(
        r'^\.requestaccess/(?P<request_id>\d+)$',
        views.AccessRequestProcessingView.as_view(),
        {'api_type': 'frontend'},
        name='process_access_request',
    ),
    url(r'^\.requestaccess$', views.RequestAccessView.as_view(), {'api_type': 'frontend'}, name='request_access'),
    url(
        r'^\.request_ownership$',
        views.RequestOwnershipView.as_view(),
        {'api_type': 'frontend'},
        name='request_ownership',
    ),
    url(
        r'^\.request_page_author$',
        views.RequestPageAuthorView.as_view(),
        {'api_type': 'frontend'},
        name='request_page_author',
    ),
    url(
        r'^\.autocomplete$',
        views.PageSupertagAutocompleteView.as_view(),
        {'api_type': 'frontend'},
        name='page_autocomplete',
    ),
    url(r'^\.tree$', views.TreeView.as_view(), {'api_type': 'frontend'}, name='tree'),
    url(r'^\.children$', views.FlatListPages.as_view(), {'api_type': 'frontend'}, name='flat_list_files'),
    url(r'^\.subpages', views.SubpagesView.as_view(), {'api_type': 'frontend'}, name='subpages'),
    url(r'^\.explainlinks$', views.ExplainLinksView.as_view(), {'api_type': 'frontend'}, name='explain_links'),
    url(r'^\.attach$', views.AttachFileView.as_view(), {'api_type': 'frontend'}, name='attach_files'),
    url(r'^\.validate_tag$', views.TagValidationView.as_view(), {'api_type': 'frontend'}, name='validate_tag'),
    url(
        r'^\.favorites/folders$',
        views.FoldersListView.as_view(),
        {'api_type': 'frontend'},
        name='favorites_folders_list',
    ),
    url(
        r'^\.favorites/folders/(?P<folder_name>.+)/drag$',
        views.ChangeFolderOrderView.as_view(),
        {'api_type': 'frontend'},
        name='change_order_of_folders',
    ),
    url(
        r'^\.favorites/folders/(?P<folder_name>.+)$',
        views.FolderView.as_view(),
        {'api_type': 'frontend'},
        name='favorites_folder_view',
    ),
    url(
        r'^\.favorites/bookmarks$', views.BookmarkCreateView.as_view(), {'api_type': 'frontend'}, name='bookmark_create'
    ),
    url(
        r'^\.favorites/bookmarks/(?P<bookmark_id>\d+)$',
        views.BookmarkEditView.as_view(),
        {'api_type': 'frontend'},
        name='bookmark_edit',
    ),
    url(
        r'^\.favorites/bookmarks/(?P<bookmark_id>\d+)/move$',
        views.MoveBookmarkView.as_view(),
        {'api_type': 'frontend'},
        name='move_bookmark',
    ),
    url(
        r'^\.favorites/bookmarks/(?P<bookmark_id>\d+)/drag$',
        views.ChangeBookmarkOrderView.as_view(),
        {'api_type': 'frontend'},
        name='change_order_of_bookmarks',
    ),
    url(r'^\.treecluster$', views.TreeClusterView.as_view(), {'api_type': 'frontend'}, name='tree_cluster'),
    url(r'^\.actuality', views.ActualityView.as_view(), {'api_type': 'frontend'}, name='actuality'),
    url(r'^\.toc$', views.PageToc.as_view(), {'api_type': 'frontend'}, name='page_toc'),
    url(
        r'^\.owner',
        views.OwnerView.as_view(),
        {'api_type': 'frontend'},
        name='owner',
    ),
    url(r'^\.authors', views.AuthorsView.as_view(), {'api_type': 'frontend'}, name='authors'),
    url(r'^\.actions_view', views.WikiActionView.as_view(), {'api_type': 'frontend'}, name='call_action'),
    url(r'^\.staff', views.StaffView.as_view(), {'api_type': 'frontend'}, name='staff'),
    url(r'^\.referrers$', views.ReferrersView.as_view(), {'api_type': 'frontend'}, name='referrers'),
    url(r'^\.tutorial$', views.TutorialView.as_view(), {'api_type': 'frontend'}, name='tutorial'),
    url(r'^\.readonly$', views.PageReadonlyModeView.as_view(), name='page_readonly_mode'),
    url(r'^\.clone$', views.PageCloneView.as_view(), {'api_type': 'frontend'}, name='page_clone'),
    url(r'^\.cloud', views.CloudPageView.as_view(), {'api_type': 'frontend'}, name='get_cloud_page'),
    url(r'^\.ensure_access', views.EnsureAccessView.as_view(), {'api_type': 'frontend'}, name='ensure_access'),
    url(
        r'^\.download_cloud_source',
        views.CloudPageDownloadSourceView.as_view(),
        {'api_type': 'frontend'},
        name='download_cloud_source',
    ),
    # WIKI-10714: отключаем в АПИ ручки экспорта, пока не будут пофикшены дырки в безопасности
    # если вдруг захочется восстановить надо переписать логику!
    # url(r'^\.export$', views.ExportView.as_view(), {'api_type': 'frontend'}, name='export'),
    # url(r'^\.export_filename$', views.ExportFilenameView.as_view(), {'api_type': 'frontend'}, name='export_filename'),
]

urlpatterns = []

if settings.IS_INTRANET:
    urlpatterns += [
        url('^integrations/', include(('wiki.integrations.ms.urls', 'wiki.integrations.ms'), namespace='ms365')),
    ]

urlpatterns += [
    url(
        r'^~(?P<login>[\w\-]+)?(/(%s)?)?' % settings.TAG_REGEX,
        views.PersonalPageRedirectView.as_view(),
        name='personal_page_redirect',
    ),
    url('^%s?' % settings.TAG_REGEX, include((page_patterns, 'wiki.api_frontend'), namespace='pages')),
    url('^%s?/' % settings.TAG_REGEX, include(('wiki.actions.urls', 'wiki.actions'), namespace='actions')),
    url(
        r'^\.autocomplete/auth$',
        views.AuthAutocompleteView.as_view(),
        {'api_type': 'frontend'},
        name='auth_autocomplete',
    ),
    url(r'^\.notes$', views.NotesView.as_view(), {'api_type': 'frontend'}, name='notes'),
    url(r'^\.upload$', views.FileUploadView.as_view(), {'api_type': 'frontend'}, name='file_upload'),
    url(
        r'^\.import/grid/upload',
        views.ImportFileUploadView.as_view(),
        {'api_type': 'frontend'},
        name='import_grid_upload',
    ),
    url(
        r'^\.import/grid/parse$',
        views.ImportFileDataParseView.as_view(),
        {'api_type': 'frontend'},
        name='import_grid_parse',
    ),
    url(
        r'^\.settings$',
        views.SettingsView.as_view(),
        {'api_type': 'frontend'},
        name='settings',
    ),
    url(r'^\.stats$', views.StatsView.as_view(), {'api_type': 'frontend'}, name='stats'),
    url(
        r'^\.notification/user_status/(?P<msg_id>\d+)$',
        views.NotificationUserStatusView.as_view(),
        {'api_type': 'frontend'},
        name='notification_user_status',
    ),
    url(r'^\.forced_sync', views.ForcedSyncView.as_view(), {'api_type': 'frontend'}, name='forced_sync'),
    url(r'^\.is_readonly$', views.ReadonlyView.as_view(), name='service_is_readonly'),
    url(r'^\.async$', AsyncRequestResultView.as_view(), name='async_request_result'),
    url(r'^\.async_test$', TestAsyncRequestView.as_view(), name='test_async_request'),
    url(r'^\.search$', QueryView.as_view(), name='query_view'),
    url(r'^\.get_document', GetDocument.as_view(), name='get_document'),
    url(r'^\.get_acl', GetAcl.as_view(), name='get_acl'),
    url(r'^\.async_operations$', AsyncRequestResultViewRecent.as_view(), name='async_operations'),
    url(r'^\.async_operations/test$', TestAsyncOperationView.as_view(), name='async_operations_test'),
    url(r'^\.async_operations/move_cluster', MoveClusterView.as_view(), name='async_operations_move_cluster'),
    url(r'^\.resolve_users_identities$', views.ResolveUsersByIdentities.as_view(), name='resolve_users_identities'),
    url(r'^\.resolve_users_logins$', views.ResolveUsersByLogins.as_view(), name='resolve_users_logins'),
]


# легаси-урлы. Для тех виджет-экшенов (tree), которые не имеют своей
# верстки в nodejs фронтэнде.
# '/_api/frontend/.actions/tree'
# работают так: отдают HTML, который отрабатывает и в старой верстке и в новой верстке.
# nodejs-верстка подключает какой-то JS, который позволяет старым виджет-экшенам работать
# все такие виджет экшены предполагается переверстать на версию с версткой в nodejs-фронте
# и версией в старом джанго-фронте.
# если у экшена из этих урлов появляется nodejs-представление, из урлов его выпиливать не нужно
# до закрытия старой верстки. А потом нужно выпилить одновременно с закрытием.

urlpatterns += [
    url('^', include('wiki.actions.urls')),
    url(r'.*', framework.NoSuchPageView.as_view(), name='no_page_view'),
]
