from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from wiki.api_core.errors.bad_request import InvalidDataSentError
from wiki.users import i18n as users_i18n
from wiki.users import logic as users_logic


def groups_by_ids(ids=None):
    groups, missing_primary_keys = users_logic.groups_by_ids(ids)

    if missing_primary_keys:
        raise InvalidDataSentError(users_i18n.no_groups_with_ids(missing_primary_keys))

    if settings.IS_INTRANET:
        # атрибут intranet_status есть только у групп из intranet.models.Group
        removed_groups = [group for group in groups if group.intranet_status == 0]
        if removed_groups:
            raise InvalidDataSentError(users_i18n.groups_with_names_have_deleted_status(removed_groups))

    return groups


def department_groups_by_ids(department_ids=None):
    if not settings.IS_INTRANET and not settings.IS_BUSINESS:
        return []
    departments, missing_primary_keys = users_logic.groups_by_department_ids(department_ids)
    if missing_primary_keys:
        raise InvalidDataSentError(
            # Translators:
            #  ru: Нет департаментов со следующими id: "%s"
            #  en: No departments with such ids: "%s"
            _('No departments with such ids: "%s"')
            % ','.join(map(str, missing_primary_keys))
        )
    return departments
