# flake8: noqa
"""
Пакет со всеми View для API.

При написании View следует стараться выносить всю логику в сериализаторы и модели,
оставляя сам View как можно более тонким.

(arc)
Относительные импорты крайне не рекомендуются — всегда указывайте абсолютный путь к модулю для всех импортирований.

Даже если модули находятся в одном пакете, используйте полное имя пакета при импортировании.
Это позволит избежать нежелательного импорта модулей пакета дважды.

"""

from django.conf import settings

from wiki.api_frontend.views.access import AccessView
from wiki.api_frontend.views.actuality import ActualityView
from wiki.api_frontend.views.authors import AuthorsView
from wiki.api_frontend.views.autocomplete import AuthAutocompleteView, PageSupertagAutocompleteView
from wiki.api_frontend.views.call_action_view import WikiActionView
from wiki.api_frontend.views.change_grid import ChangeCellAndGetBemJson, ChangeGridAndGetItAllBackView, ChangeGridView
from wiki.api_frontend.views.comments import CommentDetailView, CommentsListView
from wiki.api_frontend.views.comments_status import CommentsStatusView
from wiki.api_frontend.views.create_grid import CreateGridView
from wiki.api_frontend.views.diff import DiffView
from wiki.api_frontend.views.explainlinks import ExplainLinksView
from wiki.api_frontend.views.export import ExportFilenameView, ExportView
from wiki.api_frontend.views.favorites_bookmarks import (
    BookmarkCreateView,
    BookmarkEditView,
    ChangeBookmarkOrderView,
    MoveBookmarkView,
)
from wiki.api_frontend.views.favorites_folders import ChangeFolderOrderView, FoldersListView, FolderView
from wiki.api_frontend.views.files import AttachFileView, FilesListView, FileUploadView, FileView
from wiki.api_frontend.views.flat_list_pages import FlatListPages
from wiki.api_frontend.views.grids import (
    GridCloneView,
    GridConcurrentChangesView,
    GridDataView,
    GridExportView,
    GridRevisionView,
    GridRollbackView,
    GridRowsView,
)
from wiki.api_frontend.views.grids_import import ImportDataView, ImportFileDataParseView, ImportFileUploadView
from wiki.api_frontend.views.groups import GroupView
from wiki.api_frontend.views.keywords import KeywordsView
from wiki.api_frontend.views.move import MoveClusterView, MoveClusterViewAsync
from wiki.api_frontend.views.notes import NotesView
from wiki.api_frontend.views.notification import NotificationUserStatusView
from wiki.api_frontend.views.owner import OwnerView
from wiki.api_frontend.views.page_readonly import PageReadonlyModeView
from wiki.api_frontend.views.pages import (
    CloudPageView,
    CloudPageDownloadSourceView,
    PageCloneView,
    PageView,
    RawPageView,
    EnsureAccessView,
)
from wiki.api_frontend.views.personalpage import PersonalPageRedirectView
from wiki.api_frontend.views.placeholder import PlaceholderView
from wiki.api_frontend.views.read_only import ReadonlyView
from wiki.api_frontend.views.redirect import RedirectView
from wiki.api_frontend.views.referrers import ReferrersView
from wiki.api_frontend.views.replace_grid import ReplaceGridView
from wiki.api_frontend.views.request_access import AccessRequestProcessingView, RequestAccessView
from wiki.api_frontend.views.request_ownership import RequestOwnershipView
from wiki.api_frontend.views.request_page_author import RequestPageAuthorView
from wiki.api_frontend.views.resolve_user_by_identity import ResolveUsersByIdentities
from wiki.api_frontend.views.resolve_user_by_login import ResolveUsersByLogins
from wiki.api_frontend.views.revisions import PageEventsView, RevisionListView, RevisionView
from wiki.api_frontend.views.staff import StaffView
from wiki.api_frontend.views.stats import StatsView
from wiki.api_frontend.views.subpages import SubpagesView
from wiki.api_frontend.views.toc import PageToc
from wiki.api_frontend.views.translate import TranslateView
from wiki.api_frontend.views.tree import TreeView
from wiki.api_frontend.views.tree_cluster import TreeClusterView
from wiki.api_frontend.views.tutorial import TutorialView
from wiki.api_frontend.views.usersettings import SettingsView
from wiki.api_frontend.views.validate import TagValidationView
from wiki.api_frontend.views.watch import MassUnwatchView, MassWatchView, UnwatchView, WatchersView, WatchView
from wiki.api_frontend.views.forced_sync import ForcedSyncView

if settings.IS_INTRANET:
    from wiki.api_frontend.views.pages_officiality import OfficialityView
else:
    OfficialityView = PlaceholderView
