

from django.core.exceptions import ObjectDoesNotExist
from rest_framework.response import Response

from wiki.api_core.framework import PageAPIView
from wiki.api_core.raises import raises
from wiki.api_frontend.serializers.page_officiality import OfficialitySerializer


class OfficialityView(PageAPIView):
    """
    View с данными про официальность страницы
    """

    serializer_class = OfficialitySerializer

    @raises()
    def get(self, request, *args, **kwargs):
        """
        Получить всю информацию об официальной странице.
        %%(sh)
        curl -H "Authorization: OAuth <token>" -H "Content-Type: application/json" \
        "https://wiki-api.yandex-team.ru/_api/frontend/<tag>/.officiality"
        %%

        Для официальной страницы ответ будет
        %%(json)
        {"data": {
            "responsible_groups": [
                {
                    "id": 120,
                    "url": "yandex",  // только для инстансов Вики в Интранете
                    "name": "Яндекс",
                    "type": 1
                }
            ],
            "responsible_persons": [
                { пользователь в стандартном формате }
            ]
        }}
        %%

        Если страница не является официальной в ответе будет
        %%(json)
        {"data": {}}
        %%

        """
        page = self.request.page

        if not page.is_official:
            data = {}
        else:
            try:
                data = self.get_serializer(page.officiality).data
            except ObjectDoesNotExist:
                data = {}

        return Response(data)
