
from rest_framework import serializers
from rest_framework.response import Response

from wiki.api_core.framework import WikiAPIView
from wiki.api_core.raises import raises


class ReadonlyViewSerializer(serializers.Serializer):
    service_is_readonly = serializers.BooleanField()


class ReadonlyView(WikiAPIView):
    """
    Возвращает состояние о статусе бекэнда.

    /_api/frontend/.readonly
    """

    serializer_class = ReadonlyViewSerializer

    @raises()
    def get(self, request):
        """

        %%(sh)
        curl -H "Authorization: OAuth <token>" -H "Content-Type: application/json" \
        "https://wiki-api.yandex-team.ru/_api/frontend/.is_readonly"
        %%

        %%(json)
        { "data": {
            "service_is_readonly": false
        }}
        """
        return Response(self.get_serializer({'service_is_readonly': request.service_is_readonly}).data)
