
import logging

from wiki.api_core.errors.permissions import UserHasNoAccess
from wiki.api_core.framework import WikiAPIView
from wiki.api_core.raises import raises
from wiki.pages.logic.stats import send_stats

logger = logging.getLogger(__name__)


class StatsView(WikiAPIView):
    """
    View для сбора статистики в произвольной форме со страницы.
    """

    available_content_types = ['application/json']

    @raises()
    def post(self, request, *args, **kwargs):
        """
        Послать статистику.

        Пример запроса:

        %%(sh)
        curl -H "Authorization: OAuth <token>" -X "POST" -H "Content-Type: application/json" \
        "https://wiki-api.yandex-team.ru/_api/frontend/.stats" \
        --data 'тело запроса'
        %%

        Тело запроса: произвольный json
        """
        if request.user.is_anonymous:
            logger.warning('statistics from anonymous: %s', str(request.POST))
            raise UserHasNoAccess()

        send_stats(request)

        return self.build_success_status_response()
