
from rest_framework.response import Response

from wiki.api_core.framework import PageAPIView
from wiki.api_core.raises import raises
from wiki.api_core.utils import get_nginx_host
from wiki.api_frontend.serializers.tree import TreeRequestDeserializer
from wiki.pages.pages_tree_new import ExpandSubtreeUrlBuilder, PagesTree


class TreeView(PageAPIView):
    """
    View для получения дерева подстраниц.

    Пример запроса:

    %%(sh)
    curl -H "Authorization: OAuth <token>" -H "Content-Type: application/json" \
    "https://wiki-api.yandex-team.ru/_api/frontend/<supertag>/.tree"
    %%

    https://wiki.yandex-team.ru/wiki/components/pages-tree/
    """

    serializer_class = TreeRequestDeserializer

    @raises()
    def get(self, request, *args, **kwargs):
        get_params = self.validate(data=request.GET)

        expand_subtree_url_builder = ExpandSubtreeUrlBuilder(
            get_params=get_params,
            nginx_host=get_nginx_host(request),
        )

        return Response(
            PagesTree(
                root_supertag=request.supertag,
                user=request.user,
                expand_subtree_url_builder=expand_subtree_url_builder,
                depth=get_params['depth'] or None,
                show_redirects=get_params['show_redirects'],
                show_grids=get_params['show_grids'],
                show_files=get_params['show_files'],
                show_owners=get_params['show_owners'],
                show_titles=get_params['show_titles'],
                show_created_at=get_params['show_created_at'],
                show_modified_at=get_params['show_modified_at'],
                sort_by=get_params['sort_by'],
                sort=get_params['sort'],
                from_yandex_server=request.from_yandex_server,
                authors=get_params['authors'].split(',') if get_params['authors'] else [],
            ).data
        )

    def check_page_exists(self):
        # Можно построить дерево, корневой страницы которого не существует.
        # При этом глубже в дереве могут быть видимые подстраницы.
        pass

    def check_page_access(self):
        # Можно построить дерево, корневая страница которого закрыта от пользователя.
        # При этом глубже в дереве могут быть видимые подстраницы.
        pass
