
from urllib.parse import unquote

from django.utils.translation import ugettext as _

from wiki.api_core.errors.bad_request import InvalidDataSentError
from wiki.api_core.framework import WikiAPIView
from wiki.api_core.raises import raises
from wiki.pages.logic.tags import ValidationError, string_to_tag


class TagValidationView(WikiAPIView):
    """
    Вью для того, чтобы провалидировать пользовательский ввод на предмет того валиден ли
    введенный тег. Эта логика содержится на бекэнде, хотя возможно ей место на фронте -
    ведь это всего лишь проверка регуляркой без запросов в базу.
    """

    @raises()
    def get(self, request, *args, **kwargs):
        """
        Вернуть результат проверки тэга на валидность.

        Параметры:
        #|
        || **имя** | **тип** | **обязательность** | **описание** ||
        || %%tag%% | str | !!обязательный!! | тэг для валидации ||
        |#

        %%(sh)
        curl -H "Authorization: OAuth <token>" -X "POST" -H "Content-Type: application/json" \
        "https://wiki-api.yandex-team.ru/_api/frontend/.validate_tag?tag=yourtag"
        --data @filename
        %%

        %%(json)
        {
            "data": {
                "success": true|false
            }
        }
        """
        candidate = self.request.GET.get('tag')

        if candidate is None:
            raise InvalidDataSentError(
                # Translators:
                #  ru: Отсутствует параметр "tag"
                #  en: "tag" parameter is missing
                _('"tag" parameter is missing')
            )

        try:
            string_to_tag(unquote(candidate))
        except ValidationError:
            raise InvalidDataSentError(
                # Translators:
                #  ru: В вики не может быть страницы с адресом "%s"
                #  en: There can be no page in Wiki by this address "%s"
                _('There can be no page in Wiki by this address "%s"')
                % candidate
            )
        return self.build_success_status_response()
