
from django.conf.urls import url

from . import views

urlpatterns = [
    url(
        r'^\.directory/org/(?P<dir_org_id>\d+)$',
        views.OrganizationView.as_view(),
        name='organization',
    ),
    url(
        r'^\.directory/subscribe-to-events$',
        views.SubscribeToEventsView.as_view(),
        name='subscribe_to_events',
    ),
    url(
        r'^\.directory/subscriptions$',
        views.SubscriptionsListView.as_view(),
        name='subscriptions_list',
    ),
    url(
        r'^\.directory/subscriptions/(?P<subscription_id>\d+)$',
        views.SubscriptionView.as_view(),
        name='subscription',
    ),
    url(
        r'^\.directory/failed-syncs$',
        views.FailedSyncsView.as_view(),
        name='failed_syncs',
    ),
]
