import dataclasses
from dataclasses import dataclass
from enum import Enum
from typing import Optional, List


class DcAclType(Enum):
    # Это протокол для документ-ретривера
    DEFAULT = 'default'
    ONLY_OWNERS = 'owners'
    CUSTOM = 'custom'
    INHERITED = 'inherited'


@dataclass
class DcAcl:
    # Это протокол для документ-ретривера
    supertag: str
    acl_type: DcAclType
    document_id: Optional[str] = None
    inherits_from: Optional[str] = None
    group_ids: List[int] = dataclasses.field(default_factory=list)
    users: List[int] = dataclasses.field(default_factory=list)
    owners: List[int] = dataclasses.field(default_factory=list)


@dataclass
class DcInheritableAcl:
    # Это протокол для документ-ретривера
    acl: DcAcl
    inherits_from: Optional[DcAcl] = None
