from wiki.integrations.consts import Ms365AclManagementType
from django.conf import settings
from wiki.integrations.ms.consts import SharepointCloudSrc


def get_acl_management(cloud_src: SharepointCloudSrc) -> Ms365AclManagementType:
    try:
        if (
            cloud_src.embedding.domain == settings.MS365_MANAGED_SHAREPOINT_HOST
            and cloud_src.embedding.namespace.strip('/') == settings.MS365_MANAGED_SHAREPOINT_NAMESPACE
        ):
            return Ms365AclManagementType.WIKI
        else:
            return Ms365AclManagementType.UNMANAGED
    except KeyError:
        return Ms365AclManagementType.UNKNOWN
