from wiki.api_svc.acl.acl import get_acls
from wiki.api_svc.acl.is_managed_acl import get_acl_management
from wiki.integrations.ms.utils import get_doc_retriever_client
from wiki.pages.models import CloudPage
import logging

logger = logging.getLogger(__name__)


def secure_cloudpage(cloud_page: CloudPage):
    logger.info(cloud_page.page.supertag)
    mgmt = get_acl_management(cloud_page.get_cloud_src())

    if cloud_page.acl_management != mgmt:
        logger.info(f'Updating {cloud_page.page.supertag} setting acl_management to {mgmt}')

        client = get_doc_retriever_client()
        # noinspection PyBroadException
        try:
            client.provision_page(get_acls([cloud_page.page.supertag]))
        except Exception:
            logger.exception('Securing page FAILED')
            return

        cloud_page.acl_management = mgmt
        cloud_page.save()
        logger.info(f'Updating {cloud_page.page.supertag} SUCCESS')
    else:
        logger.info(f'Updating {cloud_page.page.supertag} is up to date')
