from rest_framework import status

from wiki.api_core.errors.rest_api_error import RestApiError


class RenderingFailedError(RestApiError):
    error_code = 'RENDERING_FAILED'
    debug_message = 'Unhandled exception occured during rendering.'


class ControlledExceptionError(RestApiError):
    error_code = 'CONTROLLED_500'
    status_code = status.HTTP_500_INTERNAL_SERVER_ERROR
    debug_message = 'This is okay.'


class Controlled502ExceptionError(RestApiError):
    error_code = 'CONTROLLED_502'
    status_code = status.HTTP_502_BAD_GATEWAY
    debug_message = 'This is okay.'
