from django.conf import settings
from django.db.models import Q
from wiki.api_svc.serializers import UserLayerSerializer, GroupLayerSerializer, DepartmentLayerSerializer
from wiki.org import get_org
from wiki.users.models import User, Group

if settings.IS_BUSINESS:
    from wiki.users.models import GROUP_TYPES

ROW_LIMIT = 5


def user_layer(text, version: str = '1'):
    """
    Очень надеюсь что мы это заменим на какую-то внешнюю ручку в Я.Орг

    SELECT ... FROM "auth_user" INNER JOIN "auth_user_orgs"
          ON ("auth_user"."id" = "auth_user_orgs"."user_id")
          LEFT OUTER JOIN "intranet_staff" ON ("auth_user"."id" = "intranet_staff"."user_id")
          WHERE ("auth_user_orgs"."organization_id" = 748 AND
          ("auth_user"."username" ILIKE %ko% OR "intranet_staff"."first_name" ILIKE %ko% OR
          "intranet_staff"."last_name" ILIKE %ko%)) LIMIT 5
    """
    users = User.objects.filter(orgs=get_org()).filter(
        Q(username__ilike=text) | Q(staff__first_name__ilike=text) | Q(staff__last_name__ilike=text)
                                | Q(staff__first_name_en__ilike=text) | Q(staff__last_name_en__ilike=text)
    )[:ROW_LIMIT]
    return [UserLayerSerializer(user, version, context={'org_id': get_org().id}).data for user in users]


def group_layer(text, version: str = '1'):
    groups = Group.objects.filter(
        title__ilike=text,
        group_type=GROUP_TYPES.group,
        org_id=get_org(),
        group_dir_type='generic',
    )[:ROW_LIMIT]
    return [GroupLayerSerializer(group, version).data for group in groups]


def department_layer(text, version: str = '1'):
    departments = Group.objects.filter(
        title__ilike=text,
        group_type=GROUP_TYPES.department,
        org_id=get_org(),
    )[:ROW_LIMIT]

    return [DepartmentLayerSerializer(department, version).data for department in departments]
