
from rest_framework import serializers


class GraphFormatterRequest(serializers.Serializer):
    output = serializers.ChoiceField(required=True, choices=['png', 'svg'])
    formatter = serializers.ChoiceField(required=True, choices=['blockdiag', 'seqdiag', 'graphviz'])
    payload = serializers.CharField(required=True)
    width = serializers.IntegerField(required=False, min_value=0, help_text='Только для png, сжать результат')
    height = serializers.IntegerField(required=False, min_value=0, help_text='Только для png, сжать результат')


class GraphFormatterResponse(serializers.Serializer):
    image_source = serializers.CharField(help_text='Base64-encoded png или svg')
