import wiki.api_svc.views as views
from django.conf.urls import url
from wiki.api_svc.views.redis_diag import RedisDiagSetView, RedisDiagGetView, RedisDiagLockView, RedisDiagMakeLockView
from wiki.e2e_testing.views.cleanup import CleanupView
from wiki.e2e_testing.views.exists import PageExistsView
from wiki.e2e_testing.views.prepare import PrepareView
from wiki.sync.cloud.views.create_organization import CreateCloudOrganizationView

urlpatterns = [
    url(r'^\.version$', views.ApiVerView.as_view(), name='svc_apiver'),
    url(r'^\.ping$', views.PingView.as_view(), name='svc_ping'),
    url(r'^\.smoke$', views.SmokeView.as_view(), name='svc_smoke'),
    url(r'^\.smoke_500$', views.Smoke500View.as_view(), name='svc_smoke'),
    url(r'^\.smoke_celery$', views.SmokeCeleryView.as_view(), name='svc_smoke'),
    url(r'^\.smoke_deprecated$', views.SmokeDeprecatedView.as_view(), name='svc_smoke'),
    url(r'^\.graph_formatter$', views.GraphFormatterView.as_view(), name='graph_formatter'),
    url(r'^acl/.get_effective_acl', views.GetEffectiveAcl.as_view(), name='get_effective_acl'),
    url(r'^acl/.verify_grantees', views.VerifyGrantees.as_view(), name='verify_grantees'),
    url(r'^\.top_pages$', views.TopPages.as_view(), name='top_pages'),
    url(r'^\.suggest$', views.SuggestView.as_view(), name='suggest'),
    url(r'^cloud/.create_organization$', CreateCloudOrganizationView.as_view(), name='create_organization'),
    url(r'^\.redis_diag/set$', RedisDiagSetView.as_view(), name='redis_diag_set'),
    url(r'^\.redis_diag/get$', RedisDiagGetView.as_view(), name='redis_diag_get'),
    url(r'^\.redis_diag/lock$', RedisDiagLockView.as_view(), name='redis_diag_lock'),
    url(r'^\.redis_diag/make_lock$', RedisDiagMakeLockView.as_view(), name='redis_diag_make_lock'),
    url(r'^e2e/.prepare', PrepareView.as_view(), name='e2e_prepare'),
    url(r'^e2e/.cleanup', CleanupView.as_view(), name='e2e_cleanup'),
    url(r'^e2e/.exists', PageExistsView.as_view(), name='e2e_exists'),
]
