from dataclasses import asdict

from django.conf import settings
from rest_framework.response import Response
from wiki.api_core.raises import raises
from wiki.api_svc.acl.acl import get_acls, verify_grantees
from wiki.api_svc.serializers import AclRequest, VerifyGranteesRequest
from wiki.api_svc.views.base import ServiceAPIView
from wiki.utils import json_ex


class GetEffectiveAcl(ServiceAPIView):
    serializer_class = AclRequest
    tvm_client_ids = [settings.DOC_RETRIEVER_ENDPOINT_TVM_CLIENT_ID]
    strict = True

    @raises()
    def post(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        acls = get_acls(serializer.validated_data['supertags'])

        return Response(json_ex.cleanup({k: asdict(v) for k, v in acls.items()}))


class VerifyGrantees(ServiceAPIView):
    serializer_class = VerifyGranteesRequest
    tvm_client_ids = [settings.DOC_RETRIEVER_ENDPOINT_TVM_CLIENT_ID]
    strict = True

    @raises()
    def post(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        good_grantees, bad_grantees = verify_grantees(
            serializer.validated_data['supertag'], serializer.validated_data['staff_ids']
        )

        return Response({'good': good_grantees, 'bad': bad_grantees})
