
from rest_framework.response import Response
from rest_framework.serializers import Serializer

from wiki.api_core.framework import WikiAPIView
from wiki.api_core.raises import raises
from wiki.utils.instance_properties import get_version, get_server
from wiki.utils.per_request_memoizer import is_memoize_on


class ApiVerView(WikiAPIView):
    serializer_class = Serializer

    @raises()
    def get(self, request, *args, **kwargs):
        return Response({'api_version': get_version(), 'handled_by': get_server(), 'memo': is_memoize_on()})
