
import logging

from rest_framework.serializers import Serializer
from ylog.context import log_context

from wiki.api_core.deprecator import deprecated_api
from wiki.api_core.framework import WikiAPIView
from wiki.api_core.raises import raises
from wiki.api_frontend.serializers.io import ok_response
from wiki.api_svc.errors import ControlledExceptionError
from wiki.api_svc.tasks import smoke_celery
from wiki.api_svc.views.base import ServiceAPIView

logger = logging.getLogger(__name__)


class PingView(ServiceAPIView):
    serializer_class = Serializer

    @raises()
    def post(self, request, *args, **kwargs):
        return ok_response()


class SmokeView(WikiAPIView):
    serializer_class = Serializer

    @raises()
    def get(self, request, *args, **kwargs):
        logger.error('Info log level working %s', 'test')

        raise ControlledExceptionError()

    @raises()
    def post(self, request, *args, **kwargs):
        raise ControlledExceptionError()


# Чтобы проверить как работает стек-трейс в бустере


def sub_fn_inner():
    raise ValueError('Smoke test')


def sub_fn():
    logger.info('This should make a breadcrumb')

    with log_context(int_val=1234, str_val='user', bool_val=True, none_val=None):
        sub_fn_inner()


class Smoke500View(WikiAPIView):
    serializer_class = Serializer

    @raises()
    def get(self, request, *args, **kwargs):
        sub_fn()


class SmokeDeprecatedView(WikiAPIView):
    serializer_class = Serializer

    @deprecated_api
    @raises()
    def get(self, request, *args, **kwargs):
        return ok_response()


class SmokeCeleryView(WikiAPIView):
    serializer_class = Serializer

    @raises()
    def get(self, request, *args, **kwargs):
        smoke_celery.delay(request.GET.get('should_crash') is not None)
        return ok_response()
