
import re

from rest_framework.response import Response

from wiki.api_core.errors.bad_request import InvalidDataSentError
from wiki.api_core.errors.permissions import UserHasNoAccess
from wiki.api_core.raises import raises
from wiki.api_svc.views.base import ServiceAPIView
from wiki.utils import metrika


def extract_tag(page_url):
    pattern = re.compile(r'^https?:.+\.ru/(.+)/(?:#.+)?$')
    supertag = pattern.findall(page_url)
    return supertag[0] if (len(supertag) > 0) else ''


class TopPages(ServiceAPIView):
    """
    Возвращает список url и супертегов страниц отсортированных по популярности
    по данным метрики
    """

    @raises(UserHasNoAccess, InvalidDataSentError)
    def get(self, request, *args, **kwargs):
        limit = request.GET.get('limit', 100)
        offset = request.GET.get('offset', 1)
        pages = []
        for page_url in metrika.get_top_pages(limit=limit, offset=offset):
            pages.append({'url': page_url, 'supertag': extract_tag(page_url)})

        return Response(pages)
