import logging

from celery.utils.log import get_task_logger
from django.conf import settings
from django_replicated.utils import routers

from wiki.api_v1.logic.page_catalog import update_page_catalog
from wiki.org import org_ctx
from wiki.utils import lock
from wiki.utils.tasks.base import LockedCallableTask

logger = logging.getLogger(__name__)


class UpdatePageCatalogTask(LockedCallableTask):
    """
    Обновить каталог страниц в MongoDB.
    """

    name = 'wiki.update_page_catalog'
    logger = get_task_logger(__name__)
    time_limit = 60 * 60

    def run(self, *args, **kwargs):
        if settings.IS_BUSINESS:
            return
        run_update_page_catalog()


@lock.get_lock_or_do_nothing('page_catalog_lock', timeout=60)
def run_update_page_catalog():
    if settings.IS_BUSINESS:
        return
    try:
        routers.use_state('slave')
        logger.info('Updating page catalog for intrasearch')
        with org_ctx(None):
            update_page_catalog()
    finally:
        routers.revert()
