
from django.conf.urls import url, include
from django.conf import settings

from wiki.api_core import framework
from . import views

page_patterns = [
    url(r'\.files/?$', views.FilesView.as_view(), {'api_type': 'v1'}, name='file_collection'),
    url(r'^\.files/(?P<filename>.+)$', views.FileView.as_view(), {'api_type': 'v1'}, name='file_single'),
    url(r'^\.search-index$', views.PageSearchIndexView.as_view(), {'api_type': 'v1'}, name='page_search_index'),
    url(r'^\.html$', views.PageHtmlView.as_view(), {'api_type': 'v1'}, name='page_html'),
]

file_patterns = [
    url(r'$', views.FileUploadView.as_view(), {'api_type': 'v1'}, name='file_upload'),
]

urlpatterns = [
    url(r'^pages/%s/' % settings.TAG_REGEX, include((page_patterns, 'wiki.api_v1'), namespace='pages')),
    url(r'^pages/\.catalog$', views.PageCatalogView.as_view(), {'api_type': 'v1'}),
    url(r'^pages/\.orgs-with-changes$', views.OrganizationsWithChangesView.as_view(), {'api_type': 'v1'}),
    url(r'^files/', include((file_patterns, 'wiki.api_v1'), namespace='files')),
    url(r'^files$', views.FileUploadView.as_view(), {'api_type': 'v1'}),
    url(r'.*', framework.NoSuchPageView.as_view(), name='no_page_view'),
]
