from django.conf import settings
from rest_framework.response import Response

from wiki.api_core.framework import WikiAPIView
from wiki.api_core.raises import raises
from wiki.api_core.utils import DirectoryRobotPermission, TVMIDPermission


class Permission(DirectoryRobotPermission):
    service_slug = 'search'


class TVMPermission(TVMIDPermission):
    tvm_client_ids = settings.PAGE_SEARCH_INDEX_ACCESS_TVM_CLIENT_IDS
    strict = False  # Пока в эту ручку ходят сервисы по OAuth не отрубаем запросы которые авторизованы не по TVM2


class OrganizationsWithChangesView(WikiAPIView):
    """
    B2B-шная ручка для интрасерча. Так как сейчас используется cloudsearch, а эта ручка ни разу не работала,
    закорачиваю
    """

    permission_classes = (TVMPermission, Permission)

    @raises()
    def get(self, request, *args, **kwargs):
        return Response([])
