
from wiki.api_core.framework import PageAPIView, Response
from wiki.api_core.raises import raises
from wiki.api_v1.views.serializers.page_html import PageHtmlSerializer


class PageHtmlView(PageAPIView):
    """
    View, отдающее HTML страницы или грида.

    %%
    curl -H "Authorization: OAuth <token>" -H "Content-Type: application/json" \
    "https://wiki-api.yandex-team.ru/_api/v1/pages/<supertag>/.html?lang=en"
    %%

    """

    @raises()
    def get(self, request, *args, **kwargs):
        return Response(PageHtmlSerializer(self.request.page, context={'request': self.request}).data)
