
from sys import maxsize

from rest_framework import serializers

from wiki.api_core.serializers.fields import TimestampField


class PageCatalogSerializer(serializers.Serializer):
    """
    Сериализатор запроса к каталогу страниц.
    """

    since = TimestampField(required=False, default=None)
    limit = serializers.IntegerField(required=False, min_value=1, max_value=(1 << 31) - 1, default=None)
    not_deleted = serializers.BooleanField(required=False, default=False)
    gt_pk = serializers.IntegerField(required=False, min_value=0, max_value=maxsize, default=None)
