import logging

from django.http import HttpRequest, HttpResponse
from django.shortcuts import render
from django.urls import reverse
from ninja import NinjaAPI
from ninja.openapi import urls

from wiki.api_v2.default_exception_handlers import subscribe_default_exception_handlers
from wiki.api_v2.private.router import private_api
from wiki.api_v2.public.router import public_api
from wiki.api_v2.utils import make_api_description
from wiki.support_tools.router import support_api

import re

logger = logging.getLogger(__name__)


def swagger_redoc(request: HttpRequest, api: 'NinjaAPI') -> HttpResponse:
    context = {
        'api': api,
        'openapi_json_url': reverse(f'{api.urls_namespace}:openapi-json'),
    }

    return render(request, 'ninja/redoc.html', context)


# манки-патчим вьюшку, с Аркадией переопределение шаблонов не работает
urls.swagger = swagger_redoc

ninja_api = NinjaAPI(title='Ya.Wiki', description=make_api_description(), version='2.0.0', urls_namespace='apiv2:api')

ninja_api.add_router('/public', public_api)
ninja_api.add_router('/private', private_api)
ninja_api.add_router('/support', support_api)

subscribe_default_exception_handlers(ninja_api)

# Сгенерим operation_id на основе основного тега + названия вьюшки без "хвоста" _view: pages__create_page
# Очистим от автоименованных хвостов: "Create Page View" -> "Create Page"

for _, router in ninja_api._routers:
    for pathoperations in router.path_operations.values():
        for operation in pathoperations.operations:
            if operation.summary:
                operation.summary = re.sub(r'\sView$', '', operation.summary)

            if not operation.operation_id and len(operation.tags) > 0:
                name = operation.view_func.__name__
                name = re.sub(r'_view$', '', name)
                operation.operation_id = f'{operation.tags[0]}__{name}'
