from django.conf import settings
from functools import wraps
from inspect import signature

from wiki.sync.connect.intranet_org import IntranetOrganization
from wiki.sync.connect.org_ctx import org_ctx


def di(fn):
    @wraps(fn)
    def wrapper(request, *args, **kwargs):
        # kwargs.update(svc)
        org = request.org if settings.IS_BUSINESS else IntranetOrganization()
        return fn(request, organization=org, *args, **kwargs)

    sig = signature(fn)
    query_params = [param for param in sig.parameters.values() if param.name != 'organization']
    # svc = {param.name: DI_CONTAINER.get_service(param.annotation) for param in sig.parameters.values() if
    #        issubclass(param.annotation, Injectable)}

    sig = sig.replace(parameters=query_params)
    wrapper.__signature__ = sig
    return wrapper


def legacy_org_ctx(fn):
    @wraps(fn)
    def wrapper(request, *args, **kwargs):
        with org_ctx(request.org):
            return fn(request, *args, **kwargs)

    return wrapper


def log_slug(request, slug: str):
    request.supertag = slug


# class Injectable:
#     pass
#
#
# class ServiceA:
#     pass
#
#
# class ServiceB:
#     pass
#
#
# class ServiceC:
#     def __init__(self, svc_a: ServiceA, svc_b: ServiceA):
#         pass
#
#
# class ServiceLoopA:
#     def __init__(self, svc_b: "ServiceLoopB"):
#         pass
#
#
# class ServiceLoopB:
#     def __init__(self, svc_a: ServiceLoopA):
#         pass
# from dataclasses import dataclass

# @dataclass
# class DependencyWrapper:
#     factory: Any
#     depends_on: List[Any]
#     visited: bool = False
#     loaded: bool = False


# class DIContainer:
#     def __init__(self):
#         self._registry = {}
#
#     def add_singleton(self, klass):
#         pass
#
#     def get_service(self, klass):
#         pass
#
#
# DI_CONTAINER = DIContainer()
