from typing import List, Optional

from ninja import Schema
from pydantic import PositiveInt, constr

from wiki.api_v2.di import di
from wiki.api_v2.schemas import StatusOk


class ValidateMe(Schema):
    required_str: str
    required_list: List[int]
    optional_str: Optional[str]
    optional_str_2: Optional[str] = None


@di
def validation_smoke_view(
    request, organization, data: ValidateMe, query_param_a: PositiveInt, query_param_b: constr(max_length=5)
) -> StatusOk:
    return StatusOk()
