from wiki.api_v2.public.grids.schemas import GridSchema
from wiki.api_v2.public.grids.views import (
    create_grid_view, get_grid_view, add_rows_view, remove_rows_view,
    add_columns_view, move_rows_view, move_columns_view,
    remove_columns_view, update_cells_view, update_rangecells_view,
)
from wiki.api_v2.router_factory import make_public_api_router
from wiki.api_v2.schemas import StatusOk

grid_router = make_public_api_router(['grids'])

grid_router.post('', response=GridSchema)(create_grid_view)
grid_router.get('/{uuid:idx}', response=GridSchema)(get_grid_view)

grid_router.post('/{uuid:idx}/rows', response=StatusOk)(add_rows_view)
grid_router.delete('/{uuid:idx}/rows', response=StatusOk)(remove_rows_view)
grid_router.post('/{uuid:idx}/columns', response=StatusOk)(add_columns_view)
grid_router.delete('/{uuid:idx}/columns', response=StatusOk)(remove_columns_view)
grid_router.put('/{uuid:idx}/cells', response=StatusOk)(update_cells_view)
grid_router.put('/{uuid:idx}/rangecells', response=StatusOk)(update_rangecells_view)

grid_router.post('/{uuid:idx}/rows/move', response=StatusOk)(move_rows_view)
grid_router.post('/{uuid:idx}/columns/move', response=StatusOk)(move_columns_view)
